#!/bin/bash

echo Argument & Input Value errors
echo args:  
echo  `./calculator ` #missing args
echo args: 1 
echo  `./calculator 1` #missing args
echo args: 1 +
echo  `./calculator 1 +` #missing args
echo args: + 1
echo  `./calculator + 1` #missing arg
echo args: a + 1
echo  `./calculator a + 1` #invalid value1
echo args: 1 + a 
echo  `./calculator 1 + a` #invalid value2
echo args: 1 + 1a 
echo  `./calculator 1 + 1a` #invalid value2
echo args: 1a + 1 
echo  `./calculator 1a + 1` #invalid value2
echo args: a + a 
echo  `./calculator a + a` #invalid val1 & val2
echo args a a a
echo  `./calculator a a a` #all inputs invalid


echo ****Invalid Operator syntax errors****
echo args: 1 ++ 1 #samma giltiga tecken
echo OUTPUT: `./calculator 1 ++ 1`
echo args: 1 -/ 1 #olika giltiga tecken
echo OUTPUT: `./calculator 1 -/ 1`
echo args: 1 1 1 
echo OUTPUT  `./calculator 1 1 1` #invalid operator
#echo args: 
#echo args:


echo
echo \****Math errors****
echo args: 2147483647 + 1 \(overflow\) 
echo OUTPUT: `./calculator 2147483647 + 1` #invalid value2
echo args: -2147483648 - 1 
echo OUTPUT: `./calculator -2147483648 - 1` #invalid value2
echo args: 1  / 0 
echo OUTPUT: `./calculator 1 / 0` #division by zero
echo
echo args: 1 % 0 NB: Function rounds input values down.  
echo OUTPUT: `./calculator 1 % 0` ##division by zero
echo 10 % 5.5 `./calculator 10 % 5.5`     
echo

echo ****Successful INTEGER Output****
echo 100 + 100: OUTPUT: `./calculator 100 + 100` 
echo 100 - 50: OUTPUT: `./calculator 100 - 50`

echo -1 - -1: OUTPUT: `./calculator -1 - -1`
echo 1 + -1
echo 100 x 100: OUTPUT: `./calculator 100 x 100`
echo 100 / 50: OUTPUT: `./calculator 100 / 50`
echo 100 % 3: OUTPUT: `./calculator 100 % 3`

echo 50 \/ 100: OUTPUT: `./calculator 50 / 100` #division by larger number
echo 50 % 100: OUTPUT: `./calculator 50 % 100`
echo 

echo ****Successful FLOAT Output****
echo 1 + 0.5 `./calculator 1 + 0.5`
echo 0.5 - 1 `./calculator 0.5 - 1`
echo 1 x 0.5 `./calculator 1 x 0.5`
echo 1 / 0.5 `./calculator 1 / 0.5`
echo 1 % 0.5 `./calculator 1 % 0.5`

echo 1 + .5 `./calculator 1 + .5` #float does not require leading zero
echo .5 + .5 `./calculator .5 + .5`
